function [area_elipse,center_distances,coeff,coeff2] = plot_PCA(Scores,Classes,Clr,S,Axes)

    % Plotting 2D data with classes
     h = gscatter(Scores(:,1),Scores(:,2),Classes,Clr,S,6,'on');                  
     for n = 1:length(h)                             
         set(h(n,1), 'MarkerFaceColor', Clr(n));
     end                   
     set(gca, 'YLimMode', 'auto');
     set(gca, 'YLimMode', 'auto');                   
     set(gca,'XLim',[-max(abs(get(gca,'XLim'))).*1.9 max(abs(get(gca,'XLim'))).*1.9]);
     set(gca,'YLim',[-max(abs(get(gca,'YLim'))).*1.9 max(abs(get(gca,'YLim'))).*1.9]);
    
     res_list = ellipseParam(Scores,2,1,2);
     % Plot the first ellipse 95%
     [hfinal,xax,yax]=ellipse_GNAT(res_list.Ellipse{1,1}, res_list.Ellipse{1,2}, 0, 0, 0, 'r','--');
     % Plot the second ellipse 99%
     hfinal2=ellipse_GNAT(res_list.Ellipse{1,3}, res_list.Ellipse{1,4}, 0, 0, 0, 'b','--');
     axis tight % optional
                   
     set(gca,'LineWidth',1);
     set(gca,'LineWidth',1);
     set(gca,'Box','on');
     line([min(xlim) max(xlim)],[0 0],'color',[1 0 0],'linestyle','--');
     line([0 0],[min(ylim) max(ylim)],'color',[1 0 0],'linestyle','--');

     xlabel(gca,Axes.AxesPlot(1),'FontSize',10, 'FontWeight','bold');
     ylabel(gca,Axes.AxesPlot(2),'FontSize',10, 'FontWeight','bold');

     grid on

     hold on;
     [area_elipse,center_distances,coeff] = Error_elipse3D(Scores(:,[(1),(2)]),Classes,Clr);
     hold off;

     coeff2 = coeff;

     legend 'off'    

     % Plotting 3D data with classes
%      h = gscatter3(...
%         Scores(:,1),...
%         Scores(:,2),...
%         Scores(:,3),...
%         Classes,Clr,S,6,'auto');   
%      axis('tight');
% 
%      % Defing the apperance 
%      set(h,'LineWidth',1);
%      set(gca,'LineWidth',1); 
%      set(gca,'Box','on');
%         
%      % Determining the limits for X, Y and Z axis
%      set(gca,'XLim',[-max(abs(get(gca,'XLim'))).*1.5 max(abs(get(gca,'XLim'))).*1.5]);
%      set(gca,'YLim',[-max(abs(get(gca,'YLim'))).*1.5 max(abs(get(gca,'YLim'))).*1.5]);
%      set(gca,'ZLim',[-max(abs(get(gca,'ZLim'))).*1.5 max(abs(get(gca,'ZLim'))).*1.5]);
% 
%      % Determining the axis labels
%      xlabel(gca,Axes.AxesPlot(1),'FontSize',10, 'FontWeight','bold');
%      ylabel(gca,Axes.AxesPlot(2),'FontSize',10, 'FontWeight','bold');
%      zlabel(gca,Axes.AxesPlot(3),'FontSize',10, 'FontWeight','bold');
%      line([min(xlim) max(xlim)],[0 0],'color',[1 0 0],'linestyle','--');
%      line([0 0],[min(ylim) max(ylim)],'color',[1 0 0],'linestyle','--');
%      line([0 0],[0 0],[min(zlim) max(zlim)],'color',[1 0 0],'linestyle','--');
% 
%      % Determining the ellipses for every class
%      hold on;
%      [area_elipse,center_distances,coeff] = Error_elipse3D(Scores(:,[(1),(2),(3)]),Classes,Clr); 
%      hold off;
%                                             
%      % Displaying the labels and legend for points
%      GNATData.labelScore = text(GNATData.parameters.Scores(:,(get(hpopupPCX,'value')))*1.1,GNATData.parameters.Scores(:,(get(hpopupPCY,'value')))*1.1,GNATData.parameters.Scores(:,(get(hpopupPCZ,'value')))*1.1,labels_s);
%      GNATData.legendScore = legend(gca,ClassesValue);
%      set(hCheckLabels,'value',1)
% 
%      grid on
%      coeff2 = coeff;
%      legend 'off'
end
